/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Size;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class RenderHelper {
    public static void outline(GuiGraphics guiGraphics, int x0, int y0, int x1, int y1, int color) {
        RenderHelper.outline(guiGraphics, x0, y0, x1, y1, color, color);
    }

    public static void outline(GuiGraphics guiGraphics, int x0, int y0, int x1, int y1, int color1, int color2) {
        int n;
        if (x1 < x0) {
            n = x0;
            x0 = x1;
            x1 = n;
        }
        if (y1 < y0) {
            n = y0;
            y0 = y1;
            y1 = n;
        }
        Matrix4f transform = guiGraphics.m_280168_().m_85850_().m_252922_();
        RenderHelper.innerHLine(transform, x0, --x1, y0, color1);
        RenderHelper.innerVLine(transform, x0, y0 + 1, --y1, color1);
        RenderHelper.innerHLine(transform, x0 + 1, x1, y1, color2);
        RenderHelper.innerVLine(transform, x1, y0 + 1, y1 - 1, color2);
    }

    public static void hLine(GuiGraphics guiGraphics, int x0, int x1, int y, int color) {
        if (x1 < x0) {
            int m = x0;
            x0 = x1;
            x1 = m;
        }
        RenderHelper.innerHLine(guiGraphics.m_280168_().m_85850_().m_252922_(), x0, x1, y, color);
    }

    protected static void innerHLine(Matrix4f transform, int x0, int x1, int y, int color) {
        RenderHelper.innerFill(transform, x0, y, x1 + 1, y + 1, color);
    }

    public static void vLine(GuiGraphics guiGraphics, int x, int y0, int y1, int color) {
        if (y1 < y0) {
            int m = y0;
            y0 = y1;
            y1 = m;
        }
        RenderHelper.innerVLine(guiGraphics.m_280168_().m_85850_().m_252922_(), x, y0, y1, color);
    }

    protected static void innerVLine(Matrix4f transform, int x, int y0, int y1, int color) {
        RenderHelper.innerFill(transform, x, y0, x + 1, y1 + 1, color);
    }

    private static void innerFill(Matrix4f transform, int x0, int y0, int x1, int y1, int color) {
        float[] cl = ColorHelper.toFloatArray(color);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(transform, (float)x0, (float)y1, 0.0f).m_85950_(cl[0], cl[1], cl[2], cl[3]).m_5752_();
        bufferBuilder.m_252986_(transform, (float)x1, (float)y1, 0.0f).m_85950_(cl[0], cl[1], cl[2], cl[3]).m_5752_();
        bufferBuilder.m_252986_(transform, (float)x1, (float)y0, 0.0f).m_85950_(cl[0], cl[1], cl[2], cl[3]).m_5752_();
        bufferBuilder.m_252986_(transform, (float)x0, (float)y0, 0.0f).m_85950_(cl[0], cl[1], cl[2], cl[3]).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void renderImage(GuiGraphics guiGraphics, int left, int top, ResourceLocation location, Size resourceSize, Rectangle uvRect, float alpha) {
        RenderHelper.renderImage(guiGraphics, left, top, uvRect.width, uvRect.height, location, resourceSize, uvRect, alpha);
    }

    public static void renderImage(GuiGraphics guiGraphics, int left, int top, int width, int height, ResourceLocation location, Size resourceSize, Rectangle uvRect, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        guiGraphics.m_280411_(location, left, top, width, height, (float)uvRect.left, (float)uvRect.top, uvRect.width, uvRect.height, resourceSize.width(), resourceSize.height());
    }
}

